;;; -*- Mode: Common-Lisp; Package: USER; Base: 10; Fonts: MEDFNT, HL12B, HL12BI -*-

(DEFUN EVAL-REMOTE (HOST form-or-string &AUX STREAM STRING delimiter value VALUES)
  "Returns all the results from evaluating FORM-OR-STRING on Host.
 FORM-OR-STRING may be a list, or a string
 If an error occurs, the error mesage is printed to *standard-output*."
  (SETF STREAM 
	(CONDITION-CASE (ERROR)
	    (CHAOS:OPEN-STREAM   HOST "EVAL" :DIRECTION :BIDIRECTIONAL :ASCII-TRANSLATION T)
	  (ERROR ERROR)))
  (IF (ERRORP STREAM) 
      (IF (NOT (STRINGP STREAM))
	  (SEND STREAM :REPORT-STRING)
	  STREAM)
      (unwind-protect
	  (progn
	    (if (stringp form-or-string)
		(WRITE-LINE form-or-string STREAM)
	      (prin1 form-or-string stream)
	      (terpri stream))
	    (write-line "Quit" stream)
	    (SEND STREAM :FORCE-OUTPUT)
	    (loop 		  
	      (multiple-value-setq (string nil delimiter)
		(read-delimited-string '(#\end #\return) stream))
	      (when (or (char= delimiter #\end) (null delimiter)) (return))
	      (SETQ VALUE (READ-FROM-STRING string nil '-error-))
	      (if (not (eq value '-error-))
		  (push-end value values)
		  ;; When an error occurs, write everything out
		  (push-end :error values)
		  (format t "~%     ~a" string)
		  (loop for ch = (read-char stream)
			until (eql ch #\end)
			do (write-char ch *standard-output*)
			(when (eql ch #\newline) (format t "     ")))
		  (return))))
	(unless (errorp stream) (send stream ':close)))
     (values-list VALUES)))

(DEFUN TURN-ON (host &aux stream)
  "Opens stream to remote host, Then turns on the eval
  server on the remote host"
  (SETF STREAM 
	(CONDITION-CASE (ERROR)
	    (CHAOS:OPEN-STREAM   HOST "REMOTE-DISK"
				 :DIRECTION :BIDIRECTIONAL
				 :ASCII-TRANSLATION T)
	  (ERROR ERROR)))
  (IF (ERRORP STREAM) 
      (IF (NOT (STRINGP STREAM))
	  (SEND STREAM :REPORT-STRING)
	  STREAM)
      (FORMAT STREAM "READ 0 #.(CHAOS:EVAL-SERVER-ON))~&")
      (CLOSE STREAM)
      );end if
  );end defun
